#include <pigpio.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <iostream>

static void err_handler (int sig) {
    gpioTerminate();
    signal(SIGINT, SIG_DFL);
    kill(getppid(), SIGINT);
    kill(getpid(), SIGINT);
    exit(0);
}

static void exit_handler () {
    gpioTerminate();
}



int pwmPin = 20;
int switchPin = 18;

using namespace std;

int main() {
   if (gpioInitialise() < 0) return 1;
    signal(SIGQUIT, err_handler);
    signal(SIGINT, err_handler);
    signal(SIGTERM, err_handler);
    signal(SIGABRT, err_handler);
    atexit(exit_handler);

    gpioSetMode(switchPin, PI_INPUT);
    gpioSetPullUpDown(switchPin, PI_PUD_DOWN);
    
    
    gpioSetMode(pwmPin, PI_OUTPUT);

    gpioPWM(pwmPin, 7);

    gpioSetPWMfrequency(pwmPin, 20);
    
    while(1) {
        int switchOn = gpioRead(switchPin);
        
        if(switchOn) {
            // a servo fully on
            gpioPWM(pwmPin, 10);
        }
        else {
            // a servo fully off
            gpioPWM(pwmPin, 5);
        }
        
        time_sleep(1);
    }
    
    
}
